//Caption:Decimation by 2, Filter Length = 30
//Cutoff Frequency Wc = %pi/2
//Pass band Edge frequency fp = 0.25 and a Stop band edge frequency fs = 0.31
// Choose the number of cosine functions and create a dense grid 
// in [0,0.25] and [0.31,0.5]
//magnitude for pass band = 1 & stop band = 0 (i.e) [1 0]
//Weighting function =[2 1]
clear;
clc;
close;
M = 30;  //Filter Length
D = 2;  //Decimation Factor = 2
Wc = %pi/2;  //Cutoff Frequency
Wp = Wc/(2*%pi);  //Passband Edge Frequency
Ws = 0.31;  //Stopband Edge Frequency
hn=eqfir(M,[0 Wp;Ws .5],[1 0],[2 1]);
disp(hn,'The LPF Filter Coefficients are:')
//Obtaining Polyphase Filter Coefficients from hn
p = zeros(D,M/D);
for k = 1:D
  for n = 1:(length(hn)/D)
    p(k,n) = hn(D*(n-1)+k);
  end
end
disp(p,'The Polyphase Decimator for D =2 are:')
//Result
//The LPF Filter Coefficients are:   
//column 1 to 7
//0.0060203  - 0.0128037  - 0.0028534    0.0136687  - 0.0046761  - 0.0197002    0.0159915

//column  8 to 14
//0.0213811  - 0.0349808  - 0.0156251    0.0640230  - 0.0073600  - 0.1187325    0.0980522  
//column 15 to 21
//0.4922476    0.4922476    0.0980522  - 0.1187325  - 0.0073600    0.0640230  - 0.0156251  
//column 22 to 28
//- 0.0349808    0.0213811    0.0159915  - 0.0197002  - 0.0046761  0.0136687  - 0.0028534

//column 29 to 30
//- 0.0128037    0.0060203 
 
//The Polyphase Decimator for D =2 are:   
//column 1 to 7
//0.0060203  - 0.0028534  - 0.0046761    0.0159915  - 0.0349808    0.0640230  - 0.1187325 
//- 0.0128037    0.0136687  - 0.0197002    0.0213811  - 0.0156251  - 0.0073600  0.0980522

//column  8 to 14
//0.4922476    0.0980522  - 0.0073600  - 0.0156251    0.0213811  - 0.0197002    0.0136687 
//0.4922476  - 0.1187325    0.0640230  - 0.0349808    0.0159915  - 0.0046761  - 0.0028534  
//column 15
//- 0.0128037  
//  0.0060203